unit UnitCanviDeParamentres;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TFormCanvideParametres = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    BitBtnOK: TBitBtn;
    BitBtnCancel: TBitBtn;
    EditMaxim: TEdit;
    EditMinim: TEdit;
    EditIncrementX: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure EditMaximExit(Sender: TObject);
    procedure EditMinimExit(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EditIncrementXExit(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    ValorMaxim,ValorMinim,IncrementX:integer;
  end;

var
  FormCanvideParametres: TFormCanvideParametres;

{************************************************}
IMPLEMENTATION
{************************************************}

{$R *.DFM}

procedure TFormCanvideParametres.FormCreate(Sender: TObject);
begin
  ValorMaxim:=128;
  ValorMinim:=20;
  IncrementX:=2;
end;

procedure TFormCanvideParametres.EditMaximExit(Sender: TObject);
var
  VMa,VMi:integer;
begin
  VMa:=StrToInt(EditMaxim.Text);
  VMi:=StrToInt(EditMinim.Text);
  if VMA>128 then begin
    MessageBox(Handle,'El valor mxim no pot ser ms gran que 128','Globus 2 - Canvi de parmetres', mb_Ok or MB_ICONSTOP);
    EditMaxim.Text:='128';
    EditMaxim.SetFocus;
  end else if VMA<=VMi then begin
    MessageBox(Handle,PChar('El valor mxim no pot ser ms petit que el valor mnim :'+EditMinim.Text),'Globus 2 - Canvi de parmetres', mb_Ok or MB_ICONSTOP);
    EditMaxim.Text:='128';
    EditMaxim.SetFocus;
  end;
  ValorMaxim:=StrToInt(EditMaxim.Text);
end;

procedure TFormCanvideParametres.EditMinimExit(Sender: TObject);
var
  VMa,VMi:integer;
begin
  VMa:=StrToInt(EditMaxim.Text);
  VMi:=StrToInt(EditMinim.Text);
  if VMi<0 then begin
    MessageBox(Handle,'El valor mnim no pot ser ms petit que 0','Globus 2 - Canvi de parmetres', mb_Ok or MB_ICONSTOP);
    EditMinim.Text:='20';
    EditMinim.SetFocus;
  end else if VMA<=VMi then begin
    MessageBox(Handle,PChar('El valor mnim no pot ser ms gran que el valor mxim :'+EditMaxim.Text),'Globus 2 - Canvi de parmetres', mb_Ok or MB_ICONSTOP);
    EditMinim.Text:='0';
    EditMinim.SetFocus;
  end;
  ValorMinim:=StrToInt(EditMinim.Text);
end;

procedure TFormCanvideParametres.EditIncrementXExit(Sender: TObject);
var
  IX:integer;
begin
  IX:=StrToInt(EditIncrementX.Text);
  if IX<1 then begin
    MessageBox(Handle,'L''increment de X no pot ser ms petit que 1','Globus 2 - Canvi de parmetres', mb_Ok or MB_ICONSTOP);
    EditIncrementX.Text:='2';
  end else if IX>16 then begin
    MessageBox(Handle,'L''increment de X no pot ser ms gran que 16','Globus 2 - Canvi de parmetres', mb_Ok or MB_ICONSTOP);
    EditIncrementX.Text:='16';
  end;
  IncrementX:=StrToInt(EditIncrementX.Text);
end;

end.
